#include <cstdio>
#include <string>
#include <thread>
#include <utility>
#include<dlfcn.h>
#include "AcpSymbolApi/AcpSymbolApi.h"

using namespace AcpSymbolApi;  // NOLINT
void ReadSymbol() {
  AcpClient client;
  client.Init("192.168.110.137");

    AcpSymbolApi::VarMap varmap;
    BOOL bool1=false;
    BYTE byte1=0;
    WORD word1=0;
    DWORD dword1=0;
    LWORD lword1=0;
    SINT sint1=0;
    USINT usint1=0;
    INT int1= 0;
    UINT uint1=0;
    DINT dint1=0;
    UDINT udint1=0;
    LINT lint1=0;
    REAL real1= 0;
    LREAL lreal1=0;
    char string1[80] = "";
       
    varmap["Application.PLC_PRG.xVar1"] = std::make_pair(&bool1, sizeof(BOOL));
    varmap["Application.PLC_PRG.bVar2"] = std::make_pair(&byte1, sizeof(BYTE));
    varmap["Application.PLC_PRG.wVar3"] = std::make_pair(&word1, sizeof(WORD));
    varmap["Application.PLC_PRG.dwVar4"] = std::make_pair(&dword1, sizeof(DWORD));
    varmap["Application.PLC_PRG.lwVar5"] = std::make_pair(&lword1, sizeof(LWORD));
    varmap["Application.PLC_PRG.siVar6"] = std::make_pair(&sint1, sizeof(SINT));
    varmap["Application.PLC_PRG.usiVar7"] = std::make_pair(&usint1, sizeof(USINT));
    varmap["Application.PLC_PRG.iVar8"] = std::make_pair(&int1, sizeof(INT));
    varmap["Application.PLC_PRG.uiVar9"] = std::make_pair(&uint1, sizeof(UINT));
    varmap["Application.PLC_PRG.diVar10"] = std::make_pair(&dint1, sizeof(DINT));
    varmap["Application.PLC_PRG.udiVar11"] = std::make_pair(&udint1, sizeof(UDINT));
    varmap["Application.PLC_PRG.liVar12"] = std::make_pair(&lint1, sizeof(LINT));
    varmap["Application.PLC_PRG.rVar13"] = std::make_pair(&real1, sizeof(REAL));
    varmap["Application.PLC_PRG.lrVar14"] = std::make_pair(&lreal1, sizeof(LREAL));
    varmap["Application.PLC_PRG.sVar15"] = std::make_pair(&string1,sizeof(string1));
  
    auto result = client.ReadSymbols(varmap);

    if (result != true) 
    {
      printf("读取失败\n");
    } 
    else 
    {
      printf("读取成功\n");
      printf("xVar1=%d\n",bool1);
      printf("bVar2=%d\n",byte1);
      printf("wVar3=%d\n", word1);
      printf("dwVar4=%u\n",dword1);
      printf("lwVar5=%ld\n",lword1);
      printf("siVar6=%d\n",sint1);
      printf("usiVar7=%d\n",usint1);
      printf("iVar8=%d\n",int1);
      printf("uiVar9=%d\n",uint1);
      printf("diVar10=%d\n",dint1);
      printf("udiVar11=%u\n",udint1);
      printf("liVar12=%ld\n",lint1);
      printf("rVar13=%f\n",real1);
      printf("lrVar14=%.8lf\n",lreal1);
      printf("sVar15=%s \n",string1);
    }
}

void WriteSymbol() {
  AcpClient client;
  client.Init("192.168.110.137");

 
    AcpSymbolApi::VarMap Writevarmap;
    BOOL bool1=false;
    BYTE byte1=27;
    WORD word1=55533;
    DWORD dword1=4000000000;
    LWORD lword1=6666666666;
    SINT sint1=-88;
    USINT usint1=222;
    INT int1= -32666;
    UINT uint1=33355;
    DINT dint1=2121212121;
    UDINT udint1= 4000000000;
    LINT lint1=8888888888;
    REAL real1= 543.9876;
    LREAL lreal1=678.1234567;
    STRING_<80> string1="Sinsegye and sinsegye";
  
          
    Writevarmap["Application.PLC_PRG.xVar1"] = std::make_pair(&bool1, sizeof(BOOL));
    Writevarmap["Application.PLC_PRG.bVar2"] = std::make_pair(&byte1, sizeof(BYTE));
    Writevarmap["Application.PLC_PRG.wVar3"] = std::make_pair(&word1, sizeof(WORD));
    Writevarmap["Application.PLC_PRG.dwVar4"] = std::make_pair(&dword1, sizeof(DWORD));
    Writevarmap["Application.PLC_PRG.lwVar5"] = std::make_pair(&lword1, sizeof(LWORD));
    Writevarmap["Application.PLC_PRG.siVar6"] = std::make_pair(&sint1, sizeof(SINT));
    Writevarmap["Application.PLC_PRG.usiVar7"] = std::make_pair(&usint1, sizeof(USINT));
    Writevarmap["Application.PLC_PRG.iVar8"] = std::make_pair(&int1, sizeof(INT));
    Writevarmap["Application.PLC_PRG.uiVar9"] = std::make_pair(&uint1, sizeof(UINT));
    Writevarmap["Application.PLC_PRG.diVar10"] = std::make_pair(&dint1, sizeof(DINT));
    Writevarmap["Application.PLC_PRG.udiVar11"] = std::make_pair(&udint1, sizeof(UDINT));
    Writevarmap["Application.PLC_PRG.liVar12"] = std::make_pair(&lint1,sizeof(LINT));
    Writevarmap["Application.PLC_PRG.rVar13"] = std::make_pair(&real1,sizeof(REAL));
    Writevarmap["Application.PLC_PRG.lrVar14"] = std::make_pair(&lreal1,sizeof(LREAL));
    Writevarmap["Application.PLC_PRG.sVar15"] = std::make_pair(&string1,sizeof(string1));
    
  
    auto result = client.WriteSymbols(Writevarmap);
    if (result != true) 
    {
      printf("写入失败\n");
    } 
    else 
    {
      printf("写入成功\n");      
    }

}

void SymbolSubReplyCallBack(SymbolSubReply* symbolSubReply) {
  //printf("SymbolSubReplyCallBack in:%d\n", symbolSubReply->type);
  int64_t subid=symbolSubReply->subid;  //取消订阅需要subid

  BOOL Subbool1=false;
  BYTE Subbyte1=0;
  WORD Subword1=0;
  DWORD Subdword1=0;
  LWORD Sublword1=0;
  SINT Subsint1=0;
  USINT Subusint1=0;
  INT Subint1= 0;
  UINT Subuint1=0;
  DINT Subdint1=0;
  UDINT Subudint1=0;
  LINT Sublint1=0;
  REAL Subreal1= 0;
  LREAL Sublreal1=0;
  char Substring1[80]="";

  if (symbolSubReply->type == SubReplyType::subscribefailed)
  {
    printf("订阅失败\n");

    if (symbolSubReply->faliedsymbolsVec.size() > 0)
    {
      printf("失败的变量: ");
      for (uint64_t i = 0; i < symbolSubReply->faliedsymbolsVec.size(); i++) 
      {
        printf("%s ", symbolSubReply->faliedsymbolsVec.at(i).c_str());
      }
      printf("\n");
    }
  } 
  else if (symbolSubReply->type == SubReplyType::subscribedelok)
  {
    printf("取消订阅成功\n");
  } 
  else if (symbolSubReply->type == SubReplyType::subscribedata)
  {
    //printf("symbolSubReply->symbolsVec.size():%ld\n", symbolSubReply->symbolsVec.size());

    for (uint64_t i = 0; i < symbolSubReply->symbolsVec.size(); i++) 
    {
      auto item = symbolSubReply->symbolsVec.at(i);

      //printf("变量名:%s\n", std::get<0>(item).c_str());
      if (std::get<0>(item) == "Application.GVL.BOOL1") 
      {
        memcpy(&Subbool1, std::get<4>(item).c_str(), sizeof(Subbool1));
        printf("Application.GVL.BOOL1: %d\n", Subbool1);
      } 
      else if (std::get<0>(item) == "Application.GVL.BYTE2")
      {
        memcpy(&Subbyte1, std::get<4>(item).c_str(), sizeof(Subbyte1));
        printf("Application.GVL.BYTE2: %d\n", Subbyte1);
      }
      else if (std::get<0>(item) == "Application.GVL.WORD3")
      {
        memcpy(&Subword1, std::get<4>(item).c_str(), sizeof(Subword1));
        printf("Application.GVL.WORD3: %d\n", Subword1);
      }
      else if (std::get<0>(item) == "Application.GVL.DWORD4")
      {
        memcpy(&Subdword1, std::get<4>(item).c_str(), sizeof(Subdword1));
        printf("Application.GVL.DWORD4: %u\n", Subdword1);
      }
      else if (std::get<0>(item) == "Application.GVL.LWORD5")
      {
        memcpy(&Sublword1, std::get<4>(item).c_str(), sizeof(Sublword1));
        printf("Application.GVL.LWORD5: %ld\n", Sublword1);
      }
      else if (std::get<0>(item) == "Application.GVL.SINT6")
      {
        memcpy(&Subsint1, std::get<4>(item).c_str(), sizeof(Subsint1));
        printf("Application.GVL.SINT6: %d\n", Subsint1);
      }
      else if (std::get<0>(item) == "Application.GVL.USINT7")
      {
        memcpy(&Subusint1, std::get<4>(item).c_str(), sizeof(Subusint1));
        printf("Application.GVL.USINT7: %d\n", Subusint1);
      }
      else if (std::get<0>(item) == "Application.GVL.INT8")
      {
        memcpy(&Subint1, std::get<4>(item).c_str(), sizeof(Subint1));
        printf("Application.GVL.INT8: %d\n", Subint1);
      }
      else if (std::get<0>(item) == "Application.GVL.UINT9")
      {
        memcpy(&Subuint1, std::get<4>(item).c_str(), sizeof(Subuint1));
        printf("Application.GVL.UINT9: %d\n", Subuint1);
      }
      else if (std::get<0>(item) == "Application.GVL.DINT10")
      {
        memcpy(&Subdint1, std::get<4>(item).c_str(), sizeof(Subdint1));
        printf("Application.GVL.DINT10: %d\n", Subdint1);
      }
      else if (std::get<0>(item) == "Application.GVL.UDINT11")
      {
        memcpy(&Subudint1, std::get<4>(item).c_str(), sizeof(Subudint1));
        printf("Application.GVL.UDINT11: %u\n",Subudint1);
      }
      else if (std::get<0>(item) == "Application.GVL.LINT12")
      {
        memcpy(&Sublint1, std::get<4>(item).c_str(), sizeof(Sublint1));
        printf("Application.GVL.LINT12: %ld\n",Sublint1);
      }
      else if (std::get<0>(item) == "Application.GVL.REAL13")
      {
        memcpy(&Subreal1, std::get<4>(item).c_str(), sizeof(Subreal1));
        printf("Application.GVL.REAL13: %f\n",Subreal1);
      }
      else if (std::get<0>(item) == "Application.GVL.LREAL14")
      {
        memcpy(&Sublreal1, std::get<4>(item).c_str(), sizeof(Sublreal1));
        printf("Application.GVL.LREAL14: %lf\n",Sublreal1);
      }
      else if (std::get<0>(item) == "Application.GVL.STRING15")
      {
        memcpy(&Substring1, std::get<4>(item).c_str(), sizeof(Substring1));
        printf("Application.GVL.STRING15: %s\n",Substring1);
      }
    }
  }
}



void SubSymbol() 
{
  AcpClient client;
  client.Init("192.168.110.137");
  client.RegisterSubSymbol(SymbolSubReplyCallBack);

  AcpSymbolApi::VarNames names;

  names.push_back("Application.GVL.BOOL1");
  names.push_back("Application.GVL.BYTE2");
  names.push_back("Application.GVL.WORD3");
  names.push_back("Application.GVL.DWORD4"); 
  names.push_back("Application.GVL.LWORD5");
  names.push_back("Application.GVL.SINT6");
  names.push_back("Application.GVL.USINT7");
  names.push_back("Application.GVL.INT8");
  names.push_back("Application.GVL.UINT9");
  names.push_back("Application.GVL.DINT10");
  names.push_back("Application.GVL.UDINT11");
  names.push_back("Application.GVL.LINT12");
  names.push_back("Application.GVL.REAL13");
  names.push_back("Application.GVL.LREAL14");
  names.push_back("Application.GVL.STRING15");
  client.AddBatchSubVar(names, 6, 15);

  while (true)
  {
    std::this_thread::sleep_for(std::chrono::milliseconds(500));
  }
}



int main() 
{
  //读取变量
  ReadSymbol();
  //写入变量
  //WriteSymbol();
  //订阅变量
  //SubSymbol();

  return 0;
}